/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.console;

import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.api.VWSIMSession;
import filenet.sim.api.VWSIMSimulationVerifyException;
import filenet.sim.apps.console.VWSIMConsoleMenuBar;
import filenet.sim.apps.console.VWSIMConsoleToolBar;
import filenet.sim.apps.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.IVWSIMConsoleActionListener;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleActionEvent;
import filenet.sim.toolkit.console.VWSIMConsoleContextMenu;
import filenet.sim.toolkit.console.VWSIMConsolePerformer;
import filenet.sim.toolkit.console.VWSIMConsoleRootNode;
import filenet.sim.toolkit.console.VWSIMSimulationLaunchResult;
import filenet.sim.toolkit.console.VWSIMSimulationNode;
import filenet.sim.toolkit.console.content.VWSIMConsoleContentPane;
import filenet.sim.toolkit.console.info.VWSIMConsoleInfoPane;
import filenet.sim.toolkit.console.property.VWSIMConsolePreferenceDialog;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.sim.toolkit.console.scope.VWSIMConsoleScopePane;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFolder;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWAboutHelper;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWBaseCore;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.event.EventListenerList;

public class VWSIMConsoleCore
extends VWBaseCore
implements ActionListener,
IVWSIMConsoleActionListener {
    private static Logger m_logger = Logger.getLogger("filenet.sim.apps.console");
    private VWSIMConsoleToolBar m_toolBar = null;
    private VWSIMConsoleMenuBar m_menuBar = null;
    private Container m_mainContainer = null;
    private Frame m_mainFrame = null;
    private JApplet m_parentApplet = null;
    private Container m_container = null;
    private JRootPane m_rootPane = null;
    private VWSplitPane m_rootSplitPane = null;
    private VWSplitPane m_viewSplitPane = null;
    private boolean m_bViewInfoPane = true;
    private VWSIMSession m_simSession = null;
    private VWSessionInfo m_sessionInfo = null;
    private VWSIMConsoleRootNode m_consoleRoot = null;
    private VWSIMConsoleRootNode m_consoleData = null;
    private VWSIMBaseNode m_focus = null;
    private VWSIMConsoleScopePane m_scopePane = null;
    private VWSIMConsoleContentPane m_contentPane = null;
    private VWSIMConsoleInfoPane m_infoPane = null;
    private EventListenerList m_listenerList = new EventListenerList();
    private VWSIMConsolePerformer m_performer = null;

    public void init(VWSessionInfo sessionInfo) {
        try {
            this.m_sessionInfo = sessionInfo;
            try {
                Locale browserLocale = sessionInfo.getBrowserLocale();
                if (browserLocale != null) {
                    sessionInfo.getSession().setClientLocale(browserLocale);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            this.m_mainContainer = sessionInfo.getParentContainer();
            this.m_parentApplet = sessionInfo.getParentApplet();
            if (this.m_mainContainer instanceof JApplet) {
                this.m_rootPane = ((JApplet)this.m_mainContainer).getRootPane();
                this.m_container = ((JApplet)this.m_mainContainer).getContentPane();
            } else if (this.m_mainContainer instanceof JFrame) {
                this.m_rootPane = ((JFrame)this.m_mainContainer).getRootPane();
                this.m_container = ((JFrame)this.m_mainContainer).getContentPane();
            }
            this.m_mainFrame = VWModalDialog.getParentFrameUsingContainer(this.m_mainContainer);
            RepaintManager repaintManager = RepaintManager.currentManager(this.m_mainContainer);
            if (!repaintManager.isDoubleBufferingEnabled()) {
                repaintManager.setDoubleBufferingEnabled(true);
            }
            this.m_simSession = new VWSIMSession();
            this.m_performer = new VWSIMConsolePerformer(this, this.m_mainContainer, this.m_mainFrame, this.m_parentApplet, this.m_sessionInfo.getSession(), this.m_simSession);
            this.m_container.setLayout(new BorderLayout());
            this.initConsole();
            super.init(sessionInfo);
            this.m_menuBar = new VWSIMConsoleMenuBar(this.m_mainContainer, this);
            this.m_menuBar.initMenuBar(this.m_bViewInfoPane);
            this.m_rootPane.setJMenuBar(this.m_menuBar);
            this.m_toolBar = new VWSIMConsoleToolBar(this);
            this.m_container.add((Component)this.m_toolBar, "First");
            this.addConsoleActionListener(this.m_toolBar);
            this.addConsoleActionListener(this.m_menuBar);
            this.addConsoleActionListener(this.m_contentPane);
            this.addConsoleActionListener(this.m_scopePane);
            this.m_contentPane.addConsoleActionListener(this.m_toolBar);
            this.m_contentPane.addConsoleActionListener(this.m_menuBar);
            this.m_contentPane.addConsoleActionListener(this);
            this.m_contentPane.addConsoleActionListener(this.m_scopePane);
            this.m_scopePane.addConsoleActionListener(this.m_toolBar);
            this.m_scopePane.addConsoleActionListener(this.m_menuBar);
            this.m_scopePane.addConsoleActionListener(this.m_contentPane);
            this.m_scopePane.addConsoleActionListener(this);
            this.m_consoleData.addConsoleStatusListener(this.m_toolBar);
            this.m_consoleData.addConsoleStatusListener(this.m_menuBar);
            this.m_consoleData.addConsoleStatusListener(this.m_infoPane);
            this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 16));
            if (this.m_mainContainer != null) {
                this.m_mainContainer.invalidate();
                this.m_mainContainer.validate();
                this.m_mainContainer.repaint();
            }
            super.performInitialRefresh();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void destroy() {
        this.performExitItemAction(false);
    }

    public void addConsoleActionListener(IVWSIMConsoleActionListener cal) {
        this.m_listenerList.add(IVWSIMConsoleActionListener.class, cal);
    }

    public void displayViewMenu(Component parent, int x, int y) {
        VWSIMConsoleContextMenu mi = new VWSIMConsoleContextMenu(6, this);
        mi.setViewMenus(this.m_bViewInfoPane);
        mi.show(parent, x, y);
    }

    public void actionPerformed(ActionEvent event) {
        block41: {
            String actionCMD = event.getActionCommand();
            Object aObj = event.getSource();
            try {
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_ABOUT) == 0) {
                    this.performAboutItemAction();
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_DELETE) == 0) {
                    if (this.m_performer.performDelete(this.m_focus)) {
                        this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 128));
                    }
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_DISCONNECT_MAP_FOLDER) == 0) {
                    this.performDeleteMappedFolder();
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_EXIT) == 0) {
                    this.performExitItemAction(true);
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_HELP) == 0) {
                    this.m_performer.performHelp(this.m_focus);
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_HELP_TOPICS) == 0) {
                    this.m_performer.performHelp(null);
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_INFO_PANE) == 0) {
                    this.performViewInfoPaneItemAction();
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_MAP_FOLDER) == 0) {
                    if (this.m_performer.performMapCeFolder(this.m_focus)) {
                        this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 32));
                    }
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_NEW_SCENARIO) == 0) {
                    this.m_performer.newScenario(this.m_focus);
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_OPEN_SCENARIO) == 0) {
                    this.m_performer.launchScenarioDesigner(this.m_focus);
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_PROPERTIES) == 0) {
                    this.m_performer.performProperties(this.m_focus);
                    this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 512));
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_PUBLISHED_DATA) == 0) {
                    this.m_performer.publishedData();
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_REFRESH) == 0) {
                    this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 544));
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_RUN_SIMULATION) == 0) {
                    VWSIMSimulationLaunchResult result = this.m_performer.launchSimulation(this.m_focus);
                    if (result == null) break block41;
                    try {
                        IVWIDMFolder[] folderList = result.getFolderFiledIn();
                        if (folderList != null && folderList.length > 0) {
                            VWSIMBaseNode focusedFolder = this.m_scopePane.getFocus();
                            String folderId = focusedFolder.getIdmItem().getId();
                            boolean bInCurrentFolder = false;
                            for (int i = 0; i < folderList.length; ++i) {
                                String filedInFolderId = folderList[i].getId();
                                if (folderId.compareTo(filedInFolderId) != 0) continue;
                                bInCurrentFolder = true;
                                break;
                            }
                            if (bInCurrentFolder) {
                                IVWSIMSimulation aIVWSIMSimulation = result.getSimulation();
                                IVWIDMDocument aIVWIDMItem = aIVWSIMSimulation.getIDMDocument();
                                VWSIMSimulationNode aSimNode = new VWSIMSimulationNode((IVWIDMItem)aIVWIDMItem, aIVWSIMSimulation, focusedFolder);
                                aSimNode.setSIMSession(this.m_simSession);
                                aSimNode.setVWSession(this.m_sessionInfo.getSession());
                                this.m_contentPane.addRow(aSimNode);
                            }
                        }
                        break block41;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_STOP_SIMULATION) == 0) {
                    this.m_performer.stopSimulation(this.m_focus);
                    this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 48));
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_SCENARIO_DESIGNER) == 0) {
                    this.m_performer.launchScenarioDesigner(this.m_focus);
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_UP) == 0) {
                    this.performUpButtonAction();
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMResource.View) == 0) {
                    JButton aButton = (JButton)aObj;
                    this.displayViewMenu(aButton, 0, aButton.getHeight());
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_VIEW_ANIMATION) == 0) {
                    try {
                        this.m_performer.viewAnimation(this.m_focus);
                    }
                    catch (VWSIMSimulationVerifyException verifyEx) {
                        if (this.m_focus.getType() == 34) {
                            VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)this.m_focus;
                            String msg = VWSIMResource.FailedVerifySimulationDoDelete.toString(aSimNode.getName());
                            int ret = JOptionPane.showConfirmDialog(this.m_mainFrame, msg, VWSIMResource.Error, 1);
                            if (ret == 0) {
                                IVWIDMDocument aIVWIDMDocument = (IVWIDMDocument)aSimNode.getIdmItem();
                                aIVWIDMDocument.delete();
                                this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 128));
                            }
                            break block41;
                        }
                        VWDebug.logException(verifyEx);
                    }
                    break block41;
                }
                if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_VIEW_SCENARIO) == 0) {
                    this.m_performer.launchScenarioDesigner(this.m_focus);
                } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_USER_PREFERENCES) == 0) {
                    VWSIMConsolePreferenceDialog dlg = new VWSIMConsolePreferenceDialog(this.m_mainFrame, this.m_sessionInfo.getSession());
                    dlg.setVisible(true);
                    if (dlg.getReturnStatus() == 1) {
                        if (dlg.folderFilterLimitModified()) {
                            int folderFilterLimit = dlg.getFolderFilterLimit();
                            this.m_consoleRoot.populateFolderFilterLimit(folderFilterLimit);
                        } else {
                            int currentFilterLimit;
                            int initialFilterLimit = this.m_consoleRoot.getFolderFilterLimit();
                            if (initialFilterLimit != (currentFilterLimit = dlg.getFolderFilterLimit())) {
                                this.m_consoleRoot.populateFolderFilterLimit(currentFilterLimit);
                            }
                        }
                        if (dlg.refreshIntervalModified()) {
                            long refreshInterval = dlg.getRefreshInterval();
                            this.m_contentPane.setRefreshInterval(refreshInterval);
                        }
                    }
                } else {
                    super.actionPerformed(event);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void consoleActionPerformed(VWSIMConsoleActionEvent evt) {
        try {
            if (evt.setFocus() && this.m_focus != evt.getBaseNode()) {
                this.m_focus = evt.getBaseNode();
                this.m_toolBar.setToolBar(this.m_focus);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performDeleteMappedFolder() {
        this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 256));
        this.m_focus = this.m_consoleRoot;
        this.m_toolBar.setToolBar(this.m_focus);
        this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 48));
    }

    protected void performRefreshItemAction() {
        this.m_contentPane.refreshContent();
    }

    protected void performViewInfoPaneItemAction() {
        if (!this.m_bViewInfoPane) {
            this.m_rootSplitPane.setDividerLocation(0.7);
            this.m_bViewInfoPane = true;
        } else {
            this.m_rootSplitPane.setDividerLocation(1.0);
            this.m_bViewInfoPane = false;
        }
    }

    protected void performExitItemAction(boolean bCloseWindow) {
        m_logger.entering("VWSIMConsoleCore", "performExitItemAction(bCloseWindow) - " + bCloseWindow);
        try {
            this.releaseReferences();
            if (!bCloseWindow) {
                return;
            }
            if (this.m_mainContainer != null && this.m_mainContainer instanceof JFrame) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JFrame)this.m_mainContainer, 201));
            } else if (this.m_mainContainer != null && this.m_mainContainer instanceof VWBaseAppLauncherApplet) {
                ((VWBaseAppLauncherApplet)this.m_mainContainer).closeWindow();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        m_logger.exiting("VWSIMConsoleCore", "performExitItemAction(bCloseWindow) - " + bCloseWindow);
    }

    protected void performAboutItemAction() {
        try {
            ImageIcon icon = VWSIMImageLoader.createImageIcon("Console_3D_32.gif");
            String productName = VWIDMBaseFactory.instance().getVWString(14).toString();
            VWAboutHelper aboutBox = new VWAboutHelper(this.m_mainFrame, productName, icon, this.m_sessionInfo);
            aboutBox.display();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performUpButtonAction() {
        VWSIMBaseNode aNode = (VWSIMBaseNode)this.m_focus.getParent();
        if (aNode != null) {
            this.m_focus = aNode;
            this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 48));
        }
        if (this.m_focus.getParent() == null) {
            this.m_toolBar.m_upButton.setEnabled(false);
        }
    }

    protected void fireConsoleActionEvent(VWSIMConsoleActionEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWSIMConsoleActionListener.class) continue;
            ((IVWSIMConsoleActionListener)listeners[i + 1]).consoleActionPerformed(evt);
        }
    }

    private void initConsole() {
        try {
            this.m_consoleRoot = new VWSIMConsoleRootNode();
            this.m_consoleRoot.init(this.m_sessionInfo.getSession(), this.m_simSession);
            this.m_consoleData = this.m_consoleRoot;
            this.m_focus = this.m_consoleRoot;
            this.m_infoPane = new VWSIMConsoleInfoPane();
            this.m_scopePane = new VWSIMConsoleScopePane();
            this.m_scopePane.init(this.m_consoleRoot, this.m_mainContainer, this.m_mainFrame, this.m_performer);
            this.m_contentPane = new VWSIMConsoleContentPane();
            this.m_contentPane.init(this.m_consoleRoot, 1, this.m_mainContainer, this.m_mainFrame, this.m_performer, this.m_sessionInfo.getSession(), this.m_simSession);
            Locale browserLocale = this.m_sessionInfo.getBrowserLocale();
            ComponentOrientation compOrientation = null;
            compOrientation = browserLocale != null ? ComponentOrientation.getOrientation(browserLocale) : ComponentOrientation.LEFT_TO_RIGHT;
            if (compOrientation.isLeftToRight()) {
                this.m_viewSplitPane = new VWSplitPane(1, this.m_scopePane, this.m_contentPane);
                this.m_viewSplitPane.setToolTipText(VWSIMResource.SlideToAdjustView);
                this.m_viewSplitPane.setOneTouchExpandable(true);
                this.m_viewSplitPane.setDividerSize(4);
                this.m_viewSplitPane.setDividerLocation(0.25);
            } else {
                this.m_viewSplitPane = new VWSplitPane(1, this.m_contentPane, this.m_scopePane);
                this.m_viewSplitPane.setToolTipText(VWSIMResource.SlideToAdjustView);
                this.m_viewSplitPane.setOneTouchExpandable(true);
                this.m_viewSplitPane.setDividerSize(4);
                this.m_viewSplitPane.setDividerLocation(0.7);
            }
            this.m_rootSplitPane = new VWSplitPane(0, this.m_viewSplitPane, this.m_infoPane);
            this.m_rootSplitPane.setToolTipText(VWSIMResource.SlideToAdjustView);
            this.m_rootSplitPane.setOneTouchExpandable(true);
            this.m_rootSplitPane.setDividerSize(2);
            if (this.m_bViewInfoPane) {
                this.m_rootSplitPane.setDividerLocation(0.7);
            } else {
                this.m_rootSplitPane.setDividerLocation(1.0);
            }
            this.m_container.add((Component)this.m_rootSplitPane, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void releaseReferences() {
        if (this.m_toolBar != null) {
            this.m_toolBar.releaseResources();
            this.m_toolBar = null;
        }
        if (this.m_menuBar != null) {
            this.m_menuBar.releaseResources();
            this.m_menuBar = null;
        }
        this.m_mainFrame = null;
        this.m_parentApplet = null;
        if (this.m_rootSplitPane != null) {
            this.m_rootSplitPane.removeAll();
            this.m_rootSplitPane = null;
        }
        if (this.m_viewSplitPane != null) {
            this.m_viewSplitPane.removeAll();
            this.m_viewSplitPane = null;
        }
        this.m_simSession = null;
        if (this.m_consoleRoot != null) {
            this.m_consoleRoot.releaseResources();
            this.m_consoleRoot = null;
            this.m_consoleData = null;
        }
        this.m_focus = null;
        if (this.m_scopePane != null) {
            this.m_scopePane.releaseResources();
            this.m_scopePane = null;
        }
        if (this.m_contentPane != null) {
            this.m_contentPane.releaseResources();
            this.m_contentPane = null;
        }
        if (this.m_infoPane != null) {
            this.m_infoPane.releaseResources();
            this.m_infoPane = null;
        }
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWSIMConsoleActionListener.class, (IVWSIMConsoleActionListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        if (this.m_performer != null) {
            this.m_performer.releaseResources();
            this.m_performer = null;
        }
        if (this.m_mainContainer != null && !(this.m_mainContainer instanceof VWBaseAppLauncherApplet)) {
            if (this.m_rootPane != null) {
                this.m_rootPane.removeAll();
            }
            if (this.m_container != null) {
                this.m_container.removeAll();
            }
            if (this.m_mainContainer != null) {
                this.m_mainContainer.removeAll();
            }
        }
        this.m_rootPane = null;
        this.m_container = null;
        this.m_sessionInfo = null;
    }
}

